// ==UserScript==
// @name         采购内容概况自适应高度 (Vue & 按钮触发)
// @match        https://ims.ynydtk.com:8443/buyv2/
// @grant        none
// @version      1.2
// @run-at       document-end
// ==/UserScript==

(function() {
    'use strict';

    // 创建按钮
    function createButton() {
        const button = document.createElement('button');
        button.textContent = '调整高度';
        button.style.cssText = `
            position: fixed;
			height: 35px;
            top: 70px;
            left: 49%;
            transform: translate(-50%); /* 居中关键 */
            z-index: 9999;
            padding: 10px 20px;
            background-color: #409EFF;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
			font-weight: bold !important;
			font-size : 14px;
        `;
        document.body.appendChild(button);
        button.addEventListener('click', adjustTextareas);
    }

    // 调整文本区域高度
    function adjustTextareas() {
        const textareas = document.querySelectorAll('.el-textarea__inner');
        textareas.forEach(textarea => {
            if (textarea.disabled) {
                textarea.style.height = 'auto';
                textarea.style.height = textarea.scrollHeight + 'px';
            }
        });
    }

    // 等待页面加载完成
	if (document.readyState === 'complete' || document.readyState === 'interactive') {
        setTimeout(createButton, 1000);
    } else {
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(createButton, 1000);
        });
    }
})();
